﻿using System;
using System.Linq;
using System.Activities;
using System.Activities.Statements;
using System.Collections.Generic;
using System.Activities.XamlIntegration;

namespace EvenOddWfHostAndClient
{
  class Program
  {
    static void Main(string[] args)
    {
        // Kod klienta służący do interakcji z użytkownikiem.
        Console.Write("Wpisz liczbę: ");
      string userInput = Console.ReadLine();

      // Sprawdzanie poprawności danych wejściowych i przetwarzanie łańcucha znaków 
      // na liczbę całkowitą (parametr result).
      int result;
      while (!int.TryParse(userInput, out result))
      {
          Console.Write("Wpisz prawidłową liczbę: ");
        userInput = Console.ReadLine();
      }

      // Wywoływanie procesu i wyświetlanie wyników.
      Console.WriteLine(EvenOddWfHost(result));

      // Wstrzymywanie programu do czasu zakończenia pracy przez użytkownika.
      Console.WriteLine("Wciśnij dowolny klawisz, aby zakończyć.");
      Console.ReadKey();
    }

    // Oddzielanie kodu hosta od kodu klienta.
    private static string EvenOddWfHost(int toCheck)
    {
        // Tworzenie kolekcji IDictionary na argument wyjściowy.
      IDictionary<string, object> output;

      // Tworzenie kolekcji IDictionary na wejściowe argumenty procesu.
      IDictionary<string, object> inputs = new Dictionary<string, object>();
      inputs.Add("NumberToCheck", toCheck);

      // Wywoływanie procesu, przekazywanie argumentów w postaci wczytywanego procesu i danych wejściowych. 
      output = WorkflowInvoker.Invoke(
        ActivityXamlServices.Load("EvenOddWf.xaml"), inputs);

      // Zwrócenie wyników.
      return output["OutputMsg"].ToString();
    }

  }
}
